#!/bin/bash
 
##########################################################################
##               conkycarousel par toulibre                             ##
##                               v 1.0                                  ##
##                          GNU GPLv3 2020                              ##
##########################################################################
 
##########################################################################
# Paramètres
##########################################################################
# Dossier où ce script cherche les images
directory="pics"
# Dimensions du carousel ("small", "medium" or "big")
dim="big"
 
##########################################################################
# Script (Ne pas changer à moins de savoir ce que vous faites)
##########################################################################

# Paramètres des dimensions de conkycarousel
if [ $dim == "small" ]; then
  geometry="158x100"
  pos="155,214"
elif [ $dim == "medium" ]; then
  geometry="238x148"
  pos="85,175"
elif [ $dim == "big" ]; then
  geometry="318x200"
  pos="0,119"
fi
 
# Prend une image aléatoire de toutes les images situées dans le dossier
files=($directory/*.*)
let r="$RANDOM % ${#files[*]}"
randomfile=${files[$r]}
 
# Ajuste l'image avec ImageMagick à partir du modèle de mise en forme de conkycarousel situé dans le dossier pix
convert $randomfile -resize $geometry\> -size $geometry xc:black +swap -gravity center  -composite current.png
convert pix/photobg_bg_$dim.png current.png -geometry +11+11 -composite result.png
convert result.png pix/photobg_shadow_$dim.png -composite result.png
echo "\${image result.png -p $pos}"
exit
